<?php
/*
If you wish to do metric logging from your backend, the best method of doing this is 
to do it in a non-blocking way. This will let your pages continue to execute at
about the same speed  while logging metric data in the background. Please note: If 
you're on a shared host, you may be limited in logging metric data with a background 
process.

Feel free to modify this code to your own environments liking
*/
class MetricsTracker {
    public $token;
    public $host = 'http://api.mixpanel.com/';
    public function __construct($token_string) {
        $this->token = $token_string;
    }
    function track($event, $properties=array()) {
        $params = array(
            'event' => $event,
            'properties' => $properties
            );

        if (!isset($params['properties']['token'])){
            $params['properties']['token'] = $this->token;
        }
        $url = $this->host . 'track/?data=' . base64_encode(json_encode($params));
        //you still need to run as a background process
        exec("curl '" . $url . "' >/dev/null 2>&1 &"); 
    }
}

$loc = array(
    "9133XXXXXXX" => "Kolkota",
    "9120XXXXXXX" => "Pune",
    "9140XXXXXXX" => "Hyderabad",
    "9144XXXXXXX" => "Chennai",
    "9111XXXXXXX" => "Delhi"
);
// Example usage:
$metrics = new MetricsTracker("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");

//$metrics->track('called',array('distinct_id'=>'9000655452'));

$metrics->track('called',array('location'=>$loc[$_REQUEST['called_number']],'distinct_id'=>$_REQUEST['cid']));

echo '<response><playtext>Thanks for calling Myntra. Your request has been recorded</playtext><hangup/></response>';

?>
